-- Generated by tools/imgui_upgrader/build_enums.lua

local ImGuiConfigFlags_None                 = 0
local ImGuiConfigFlags_NavEnableKeyboard    = 1       -- 1 << 0
local ImGuiConfigFlags_NavEnableGamepad     = 2       -- 1 << 1
local ImGuiConfigFlags_NavEnableSetMousePos = 4       -- 1 << 2
local ImGuiConfigFlags_NavNoCaptureKeyboard = 8       -- 1 << 3
local ImGuiConfigFlags_NoMouse              = 16      -- 1 << 4
local ImGuiConfigFlags_NoMouseCursorChange  = 32      -- 1 << 5
local ImGuiConfigFlags_IsSRGB               = 1048576 -- 1 << 20
local ImGuiConfigFlags_IsTouchScreen        = 2097152 -- 1 << 21

imgui.ConfigFlags = {
	None                 = ImGuiConfigFlags_None,
	NavEnableKeyboard    = ImGuiConfigFlags_NavEnableKeyboard,    -- Master keyboard navigation enable flag. Enable full Tabbing + directional arrows + space/enter to activate.
	NavEnableGamepad     = ImGuiConfigFlags_NavEnableGamepad,     -- Master gamepad navigation enable flag. Backend also needs to set ImGuiBackendFlags_HasGamepad.
	NavEnableSetMousePos = ImGuiConfigFlags_NavEnableSetMousePos, -- Instruct navigation to move the mouse cursor. May be useful on TV/console systems where moving a virtual mouse is awkward. Will update io.MousePos and set io.WantSetMousePos=true. If enabled you MUST honor io.WantSetMousePos requests in your backend, otherwise ImGui will react as if the mouse is jumping around back and forth.
	NavNoCaptureKeyboard = ImGuiConfigFlags_NavNoCaptureKeyboard, -- Instruct navigation to not set the io.WantCaptureKeyboard flag when io.NavActive is set.
	NoMouse              = ImGuiConfigFlags_NoMouse,              -- Instruct imgui to clear mouse position/buttons in NewFrame(). This allows ignoring the mouse information set by the backend.
	NoMouseCursorChange  = ImGuiConfigFlags_NoMouseCursorChange,  -- Instruct backend to not alter mouse cursor shape and visibility. Use if the backend cursor changes are interfering with yours and you don't want to use SetMouseCursor() to change mouse cursor. You may want to honor requests from imgui by reading GetMouseCursor() yourself instead.
	IsSRGB               = ImGuiConfigFlags_IsSRGB,               -- Application is SRGB-aware.
	IsTouchScreen        = ImGuiConfigFlags_IsTouchScreen,        -- Application is using a touch screen instead of a mouse.
}
